% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_summary_stats.R
\name{calculate_summary_stats}
\alias{calculate_summary_stats}
\title{Calculate Summary Statistics}
\usage{
calculate_summary_stats(data, input_groups = "ATPTREF")
}
\arguments{
\item{data}{A data frame containing results of
Non Compartmental Analysis using PKNCA package. Assumes
presence of columns: PPORRES, PPSTRES, PPSTRESU, PPTESTCD}

\item{input_groups}{A character vector specifying the columns to group by.
Here. the hierarchical order matters
Default is "PPSTRESU".}
}
\value{
A data frame with summary statistics for each group and parameter.
}
\description{
This function calculates various summary statistics for formatted output of PKNCA::pk.nca().
}
\details{
The function calculates the following statistics for numeric variables:
\itemize{
\item Geometric mean (\code{geomean})
\item Geometric coefficient of variation (\code{geocv})
\item Arithmetic mean (\code{mean})
\item Standard deviation (\code{sd})
\item Minimum value (\code{min})
\item Maximum value (\code{max})
\item Median value (\code{median})
\item Count of missing values (\code{count.missing})
\item Count (\code{count})
}
The resulting summary statistics are rounded to three decimal places.
If units are different, they are standardized to the group's most frequent first unit.
}
\examples{
data <- data.frame(
  ATPTREF = c(1, 1, 1, 1, 1, 1),
  PPTESTCD = c("A", "A", "B", "B", "C", "C"),
  PPORRES = c(10, 20, 5, 15, NA, 30),
  PPSTRES = c(10, 20, 5, 15, NA, 30),
  PPORRESU = c("mg/L", "mg/L", "ng/mL", "ng/mL", "µg/L", "µg/L"),
  PPSTRESU = c("mg/L", "mg/L", "ng/mL", "ng/mL", "µg/L", "µg/L")
)
calculate_summary_stats(data)
}
