% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_slope_plot.R
\name{lambda_slope_plot}
\alias{lambda_slope_plot}
\title{Generate a Lambda Slope Plot}
\usage{
lambda_slope_plot(
  conc_pknca_df,
  row_values,
  myres = myres,
  r2adj_threshold = 0.7,
  time_column = "AFRLT"
)
}
\arguments{
\item{conc_pknca_df}{Data frame containing the concentration data
(default is \code{mydata$conc$data}).}

\item{row_values}{A list containing the values for the column_names used for filtering.}

\item{myres}{A PKNCAresults object containing the results of the NCA analysis}

\item{r2adj_threshold}{Numeric value representing the R-squared adjusted threshold for
determining the subtitle color (default is 0.7).}

\item{time_column}{The name of the time column in the concentration data frame.
(default is "AFRLT").}
}
\value{
A plotly object representing the lambda slope plot.
}
\description{
This function generates a lambda slope plot using pharmacokinetic data. It calculates relevant
lambda parameters and visualizes the data points used for lambda calculation, along with
a linear regression line and additional plot annotations.
}
\details{
The function performs the following steps:
\itemize{
\item{Creates duplicates of the pre-dose and last doses of concentration data.}
\item{Filters and arranges the input data to obtain relevant lambda calculation information.}
\item{Identifies the data points used for lambda calculation.}
\item{Calculates the fitness, intercept, and time span of the half-life estimate.}
\item{
Determines the subtitle color based on the R-squared adjusted value and half-life estimate.
}
\item{
Generates a ggplot object with the relevant data points,
linear regression line, and annotations.
}
\item{Converts the ggplot object to a plotly object for interactive visualization.}
}
}
\examples{
\donttest{
if (interactive()) {
  # Load a small packaged example dataset
  adnca <- read.csv(system.file("shiny/data/Dummy_data.csv", package = "aNCA"))

  # Subset to a single subject to keep the example fast
  subj1 <- unique(adnca$USUBJID)[3]
  dose1 <- unique(adnca$DOSNOP)[1]
  adnca_sub <- adnca[adnca$USUBJID == subj1 & adnca$DOSNOP == dose1, ]

  # Analysis details (minimal example)
  method <- "lin up/log down"
  params <- c("cmax", "tmax", "auclast", "aucinf.obs")
  analytes <- unique(adnca_sub$PARAM)
  dosnos <- unique(adnca_sub$ATPTREF)
  pcspecs <- unique(adnca_sub$PCSPEC)
  auc_data <- data.frame(start_auc = numeric(), end_auc = numeric())

  # Build a minimal PKNCA data object and run NCA (kept in \donttest for CRAN safety)
  pknca_data <- PKNCA_create_data_object(adnca_sub)
  pknca_data <- create_start_impute(pknca_data)
  pknca_data <- PKNCA_update_data_object(
    pknca_data,
    auc_data = auc_data,
    method = method,
    params = params,
    selected_analytes = analytes,
    selected_profile = dosnos,
    selected_pcspec = pcspecs
  )

  pknca_res <- PKNCA_calculate_nca(pknca_data)

  # Create the lambda slope plot for the example subject
  plot <- lambda_slope_plot(
    conc_pknca_df = pknca_data$conc$data,
    row_values = list(USUBJID = subj1, STUDYID = unique(adnca_sub$STUDYID)[1], DOSNOA = 1),
    myres = pknca_res,
    r2adj_threshold = 0.7
  )
  print(plot)
}
}
}
