% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_zinarp.R
\name{estimate_zinarp}
\alias{estimate_zinarp}
\title{Parameter estimation for ZINARp models}
\usage{
estimate_zinarp(
  x,
  p,
  iter = 5000,
  thin = 2,
  burn = 0.1,
  innovation = "Poisson"
)
}
\arguments{
\item{x}{A vector containing a discrete non-negative time series dataset.}

\item{p}{The order of the INAR/ZINAR process.}

\item{iter}{The number of iterations to be considered. Defaults to 5000.}

\item{thin}{Lag for posterior sample. Defaults to 2.}

\item{burn}{Burn-in for posterior sample. Defaults to 0.1. Must be in (0,1).}

\item{innovation}{Distribution to be used for the innovation : "Poisson" or "ZIP". Defaults to Poisson.}
}
\value{
Returns a list containing a posteriori samples for the specified model parameters.
}
\description{
This function uses MCMC algorithms (Metropolis-Hastings and Gibbs Sampler) to generate a chain of INAR/ZINAR(p) parameter estimators.
}
\examples{
test <- simul_zinarp(alpha = 0.1, lambda = 1, n = 100)
e.test <- estimate_zinarp(x = test, p = 1, iter = 800, innovation= "Poisson")
alpha_hat <- mean(e.test$alpha)
lambda_hat <- mean(e.test$lambda)

data(slesions)
e.slesions <- estimate_zinarp(slesions$y, p = 1, iter = 800, innovation = 'ZIP')
alpha_hat_slesions <- mean(e.slesions$alpha)
lambda_hat_slesions <- mean(e.slesions$lambda)
rho_hat_slesions <- mean(e.slesions$rho)
}
\references{
Garay, Aldo M., Francyelle L. Medina, Celso RB Cabral, and Tsung-I. Lin. "Bayesian analysis of the p-order integer-valued AR process with zero-inflated Poisson innovations." Journal of Statistical Computation and Simulation 90, no. 11 (2020): 1943-1964.

Garay, Aldo M., Francyelle L. Medina, Isaac Jales CS, and Patrice Bertail. "First-Order Integer Valued AR Processes with Zero-Inflated Innovations." In Workshop on Nonstationary Systems and Their Applications, pp. 19-40. Springer, Cham, 2021.
}
