% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_fi.r
\name{bp_opt}
\alias{bp_opt}
\title{Find the best fit for individual trials using \code{optim}}
\usage{
bp_opt(r_times, trial_duration, optim_method = "Brent")
}
\arguments{
\item{r_times}{Vector of response times}

\item{trial_duration}{Duration of the trial}

\item{optim_method}{character, the optimization method to use}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{bp}: The breakpoint
\item \code{r1}: The response rate before the breakpoint
\item \code{r2}: The response rate after the breakpoint
\item \code{d1}: The duration of the first state
\item \code{d2}: The duration of the second state
}
}
\description{
Find the best fit for individual trials by minimizing the
negative sum of areas between the response rate and the target rate.
}
\examples{
data("r_times")
r_times <- r_times[r_times < 60]
bp_from_opt <- bp_opt(r_times, 60)
plot(r_times, seq_along(r_times),
  xlim = c(0, max(r_times)),
  main = "Cummulative Record",
  xlab = "Time (s)",
  ylab = "Cum Resp",
  col = 2, type = "s"
)
abline(v = bp_from_opt$bp)
}
