% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve.R
\name{solve-methods}
\alias{solve-methods}
\alias{solve}
\alias{solve,GWoodburyMatrix,missing-method}
\alias{solve,GWoodburyMatrix,numLike-method}
\alias{solve,GWoodburyMatrix,matrix-method}
\alias{solve,GWoodburyMatrix,ANY-method}
\alias{solve,SWoodburyMatrix,missing-method}
\alias{solve,SWoodburyMatrix,numLike-method}
\alias{solve,SWoodburyMatrix,matrix-method}
\alias{solve,SWoodburyMatrix,ANY-method}
\title{Solve methods for \code{WoodburyMatrix} objects}
\usage{
\S4method{solve}{GWoodburyMatrix,missing}(a)

\S4method{solve}{GWoodburyMatrix,numLike}(a, b)

\S4method{solve}{GWoodburyMatrix,matrix}(a, b)

\S4method{solve}{GWoodburyMatrix,ANY}(a, b)

\S4method{solve}{SWoodburyMatrix,missing}(a)

\S4method{solve}{SWoodburyMatrix,numLike}(a, b)

\S4method{solve}{SWoodburyMatrix,matrix}(a, b)

\S4method{solve}{SWoodburyMatrix,ANY}(a, b)
}
\arguments{
\item{a}{\code{WoodburyMatrix} object.}

\item{b}{Matrix, vector, or similar (needs to be compatible with the
submatrices \code{a@A} and \code{a@V} or \code{a@X} that define the
\code{WoodburyMatrix}).}
}
\value{
The solution to the linear system, or the inverse of the matrix. The
class of the return value will be a vector if \code{b} is a vector, and may
otherwise be either a regular matrix or a subclass of
\code{\link[Matrix:Matrix-class]{Matrix}}, with the specific subclass determined
by \code{a} and \code{b}.
}
\description{
Methods based on \code{\link{solve}} to solve a linear system of equations
involving \code{\linkS4class{WoodburyMatrix}} objects. These methods take
advantage of the Woodbury matrix identity and therefore can be much more
time and memory efficient than forming the matrix directly.

Calling this function while omitting the \code{b} argument returns the
inverse of \code{a}. This is NOT recommended, since it removes any benefit
from using an implicit representation of \code{a}.
}
\section{Functions}{
\itemize{
\item \code{solve(a = GWoodburyMatrix, b = missing)}: Invert the matrix

\item \code{solve(a = GWoodburyMatrix, b = numLike)}: Solve the linear system

\item \code{solve(a = GWoodburyMatrix, b = matrix)}: Solve the linear system

\item \code{solve(a = GWoodburyMatrix, b = ANY)}: Solve the linear system

\item \code{solve(a = SWoodburyMatrix, b = missing)}: Invert the symmetric matrix

\item \code{solve(a = SWoodburyMatrix, b = numLike)}: Solve the linear system

\item \code{solve(a = SWoodburyMatrix, b = matrix)}: Solve the linear system

\item \code{solve(a = SWoodburyMatrix, b = ANY)}: Solve the linear system

}}
\seealso{
\link{WoodburyMatrix}, \linkS4class{WoodburyMatrix}
}
