% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaveletSVR.R
\name{WaveletFittingsvr}
\alias{WaveletFittingsvr}
\title{Wavelet-SVR Hybrid Model for Forecasting}
\usage{
WaveletFittingsvr(
  ts,
  tlag = ACF,
  Waveletlevels,
  WaveletFilter = "haar",
  boundary = "periodic",
  FastFlag = TRUE,
  SplitRatio = 0.8
)
}
\arguments{
\item{ts}{Univariate time series}

\item{tlag}{Number of lags}

\item{Waveletlevels}{The level of wavelet decomposition}

\item{WaveletFilter}{Wavelet filter use in the decomposition}

\item{boundary}{The boundary condition of wavelet decomposition}

\item{FastFlag}{The FastFlag condition of wavelet decomposition: True or False}

\item{SplitRatio}{Training and testing data split}
}
\value{
\itemize{
  \item TrainFittedValue - Fitted value of train data
  \item TestPredictedValue - Predicted value of test data
  \item AccuracyTable - RMSE and MAPE of train and test data
}
}
\description{
The main aim of this package is to combine the advantage of wavelet and Support Vector Regression (SVR) models for time series forecasting. This package also gives the accuracy measurements in terms of Root Mean Square Error (RMSE) and Mean Absolute Prediction Error (MAPE).
}
\examples{
data<-rnorm(100,mean=100,sd=50)
WSVR<-WaveletFittingsvr(ts=data,tlag=2,Waveletlevels=3)
}
\references{
\itemize{
\item Aminghafari, M. and Poggi, J.M. 2007. Forecasting time series using wavelets. Internationa Journal of Wavelets, Multiresolution and Inforamtion Processing, 5, 709 to 724
\item Percival, D. B. and Walden A. T. 2000. Wavelet Methods for Time-Series Analysis. Cambridge Univ. Press, U.K.
\item Paul, R. K., Prajneshu and Ghosh H. 2013. Wavelet Frequency Domain Approach for Modelling and Forecasting of Indian Monsoon Rainfall Time-Series Data. Journal of the Indian society of agricultural statistics, 67, 319 to 327.
\item Paul, R. K. and Birthal, P.S. 2015. Investigating rainfall trend over India using wavelet technique. Journal of Water and Climate Change, 7, 365 to 378.
\item Paul, R. K. 2015. ARIMAX-GARCH-WAVELET Model for forecasting volatile data. Model Assisted Statistics and Application, 10, 243 to 252.
\item Raimundo, M. S.  and Okamoto, J. 2018. SVR-wavelet adaptive model for forecasting financial time series. International Conference on Information and Computer Technologies (ICICT), 111-114, doi: 10.1109/INFOCT.2018.8356851.
}
}
