% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetRatesC.R
\name{GetRatesC}
\alias{GetRatesC}
\title{Retrieves Cohort Data from the HMD and HFD and Obtains Cohort Rates}
\usage{
GetRatesC(country, user, pw_HMD, pw_HFD, refcohort)
}
\arguments{
\item{country}{Code of the country selected. The code must be one of the country codes of HMD and HFD.}

\item{user}{Name of the user, used at registration with the HMD and HFD. It
is assumed that the same name is used for both HMD and HFD.}

\item{pw_HMD}{Password to access HMD, provided at registration.}

\item{pw_HFD}{Password to access HFD, provided at registration}

\item{refcohort}{Year of birth of cohort for which the data are used for the simulation.}
}
\value{
A list object with three elements: 
\item{ASDR}{Age-specific death rates by sex for selected birth cohort} 
\item{ASFR}{Age-specific fertility rates by parity for selected birth cohort}
\item{ratesM}{Matrix of transition rates in format required for mulitstate modelling}
The object returned by the function has five attributes:
\item{country}{Country}
\item{type}{Type of data (period data or cohort data)}
\item{cohort}{Birth cohort (year of birth}
\item{refyear}{Calendar year for which period death rates are used to complete cohort experience in case of incomplete mortality experience (reference year).}
\item{start_pASDR}{Lowest age for which cohort data are missing. The mortality rates of that age and higher ages are borrowed from period data collected in the reference year.}
}
\description{
Retrieves cohort data from the HMD and HFD and produces cohort rates 
(death rates by age and sex and conditional fertility rates by age and parity). 
The function combines the steps of (a) data retrieval and (b) extraction of mortality and fertility rates.
}
\examples{
\dontrun{
ratesC  <- GetRatesC(country="USA",user,pw_HMD,pw_HFD,refcohort)
}


}
