% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlehac.R
\name{mlehac}
\alias{mlehac}
\title{mlehac}
\usage{
mlehac(sample, dim, type, start_val = NULL)
}
\arguments{
\item{sample}{A sample from a \eqn{q}-dimensional random vector \eqn{\mathbf{X}} (\eqn{n \times q} matrix with observations in rows, variables in columns).}

\item{dim}{The vector of dimensions \eqn{(d_{1},...,d_{k})}.}

\item{type}{The type of Archimedean copula.}

\item{start_val}{The starting values for the parameters \eqn{(\theta_{0},\theta_{1},...,\theta_{k})} of the \cr
hierarchical Archimedean copula.}
}
\value{
The maximum pseudo-likelihood estimates for \eqn{(\theta_{0},\theta_{1}, \dots, \theta_{k})}.
}
\description{
Given a \eqn{q}-dimensional random vector \eqn{\mathbf{X} = (\mathbf{X}_{1},...,\mathbf{X}_{k})} with \eqn{\mathbf{X}_{i}} a \eqn{d_{i}}-dimensional random vector, i.e., \eqn{q = d_{1} + ... + d_{k}},
this function performs maximum pseudo-likelihood estimation for the parameters of
a hierarchical Archimedean copula with two nesting levels of a specific type, used for modelling the dependence between \eqn{\mathbf{X}_{1}, \dots, \mathbf{X}_{k}}.
}
\details{
Under the assumption that \eqn{\mathbf{X} = (\mathbf{X}_{1}, \dots, \mathbf{X}_{k})} has a hierarchical Archimedean copula with two nesting levels, i.e.,
\deqn{C(\mathbf{u}) = C_{0} \left (C_{1}(\mathbf{u}_{1}), \dots, C_{k}(\mathbf{u}_{k}) \right ),}
where \eqn{\mathbf{u} = (\mathbf{u}_{1}, \dots, \mathbf{u}_{k}) \in \mathbb{R}^{q}} with \eqn{\mathbf{u}_{i} \in \mathbb{R}^{d_{i}}} for \eqn{i = 1, \dots, k},
and with \eqn{\theta_{i}} the parameter of \eqn{C_{i}} for \eqn{i = 0,1, \dots, k} (see the function \code{\link{gethac}}), this functions performs maximum pseudo-likelihood estimation for
\eqn{\boldsymbol{\theta}_{C} = (\theta_{0}, \theta_{1}, \dots, \theta_{k})}. This means that for \eqn{\widehat{F}_{ij}(x_{ij}) = \frac{1}{n+1} \sum_{\ell = 1}^{n} 1 \left (X_{ij}^{(\ell)} \leq x_{ij} \right )} the (rescaled) empirical cdf of \eqn{X_{ij}} based on a sample \eqn{X_{ij}^{(1)}, \dots, X_{ij}^{(n)}}
for \eqn{i = 1, \dots, k} and \eqn{j = 1, \dots, d_{i}} (recall that \eqn{\mathbf{X}_{i} = (X_{i1}, \dots, X_{id_{i}})}),
we look for \deqn{\widehat{\boldsymbol{\theta}}_{C,n}^{\text{NP}} = \text{arg max}_{\boldsymbol{\theta}_{C}} \sum_{\ell = 1}^{n} \ln \left \{c \left ( \widehat{F}_{11} \left (X_{11}^{(\ell)} \right ), \dots, \widehat{F}_{kd_{k}} \left (X_{kd_{k}}^{(\ell)} \right ) ; \boldsymbol{\theta}_{C} \right ) \right \},}
where \eqn{c( \cdot ; \boldsymbol{\theta}_{C})} is the copula density of the hierarchical Archimedean copula.

We assume that \eqn{C_{i}} belongs to the same family of Archimedean copulas (e.g., Clayton) for \eqn{i = 0, \dots, k},
and make use of the R package \sQuote{HAC}.

In case the starting values (start_val) are not specified, the starting value for \eqn{\theta_{0}} is put equal to 1.9
and the starting values for \eqn{\theta_{i}} with \eqn{i \in \{1, \dots, k \}} are determined by performing
maximum pseudo-likelihood estimation to the \eqn{d_{i}}-dimensional marginals with starting value \eqn{2}.
}
\examples{
dim = c(2,2)
thetas = c(2,3,4)

# Sample size
n = 1000

# 4 dimensional nested Gumbel copula with (theta_0,theta_1,theta_2) = (2,3,4)
HAC = gethac(dim,thetas,type = 1)

# Sample
sample = suppressWarnings(HAC::rHAC(n,HAC))

# Maximum pseudo-likelihood estimator with starting values equal to thetas
HAC_est_1 = mlehac(sample,dim,1,thetas)

# Maximum pseudo-likelihood estimator with starting values
# theta_0 = 1.9, and theta_1, theta_2 determined by maximum
# pseudo-likelihood estimation for marginal child copulas

HAC_est_2 = mlehac(sample,dim,1)


}
\references{
De Keyser, S. & Gijbels, I. (2024).
Parametric dependence between random vectors via copula-based divergence measures.
Journal of Multivariate Analysis 203:105336. \cr
doi: https://doi.org/10.1016/j.jmva.2024.105336.

Okhrin, O., Ristig, A. & Chen, G. (2024).
HAC: estimation, simulation and visualization of hierarchical Archimedean copulae (HAC), R package version 1.1-1. \cr
url:  https://CRAN.R-project.org/package=HAC.
}
\seealso{
\code{\link{gethac}} for creating a hac object with two nesting levels,
\code{\link{phihac}} for computing the \eqn{\Phi}-dependence between all the child copulas of a hac object with two nesting levels,
\code{\link{Helhac}} for computing the Hellinger distance between all the child copulas of a hac object with two nesting levels.
}
