% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Acoef_sh.R
\name{Acoef_sh}
\alias{Acoef_sh}
\title{Coefficient matrices of endogenous variables}
\usage{
Acoef_sh(x)
}
\arguments{
\item{x}{An object of class "varshrinkeset", generated by VARshrink().}
}
\value{
A list object with K-by-K VAR coefficient matrices A_1, A_2, ..., A_p
}
\description{
Returns the estimated coefficient matrices of the lagged endogenous
variables of a VAR(p) model.
This is a modification of vars::Acoef() for the class "varshrinkest".
}
\details{
Consider VAR(p) model:
\deqn{y_t = A_1 y_{t-1} + ... + A_p y_{t-p} + C d_t + e_t .}
The function returns the K-by-K matrices {A_1, ..., A_p} as a list object.
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim <- VARshrink(y, p = 2, type = "const", method = "ridge")
Acoef_sh(estim)
}
\seealso{
\code{\link[vars]{Acoef}}
}
