% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenario_uncertainty.R
\name{scenario_uncertainty}
\alias{scenario_uncertainty}
\title{Scenario uncertainty(DEPRECATED)}
\usage{
scenario_uncertainty(data, var_name, stages = setdiff(names(data),
  var_name))
}
\arguments{
\item{data}{a data frame containing scenarios(factor or character) for each stages and the variable of interest(numeric).
data should contain all combinations of scenarios.}

\item{var_name}{the name of the variable of interest}

\item{stages}{names of the stages of interest.}
}
\value{
List of 4 elements
\item{summary}{summary of uncertainties}
\item{main_uncer}{list of which element is a vector of uncertainties from the main effects of scenarios in the corresponding stage}
\item{int_uncer}{list of which element is a vector of uncertainties from the interaction effects of scenarios in the corresponding stage}
\item{scenario_uncer}{list of which element is a vector of uncertainties of scenarios in the corresponding stage}
}
\description{
This function performs uncertainty decomposition by scenario based on the second order interaction ANOVA model.
The uncertainty from interaction effect from two scenarios is divided equally and assigned to each scenario.
}
\examples{
stage1 <- LETTERS[1:3]
stage2 <- LETTERS[1:2]
stage3 <- LETTERS[1:4]
y <- rnorm(3*2*4)
data <- expand.grid(stage1=stage1,
                    stage2=stage2,
                    stage3=stage3)
data <- cbind(data, y)
# scenario_uncertainty() is deprecated. Use UD_ANOVA_model()
# scenario_uncertainty(data,"y", names(data)[-4])
}
