% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/USPFourierAdapt.R
\name{USPFourierAdapt}
\alias{USPFourierAdapt}
\title{Adaptive permutation test of independence for continuous data.}
\usage{
USPFourierAdapt(x, y, alpha, B = 999, ties.method = "standard")
}
\arguments{
\item{x}{The vector of data points from the first sample, each entry belonging to \eqn{[0,1]}.}

\item{y}{The vector of data points from the second sample, each entry belonging to \eqn{[0,1]}.}

\item{alpha}{The desired significance level of the test.}

\item{B}{Controls the number of permutations to be used. With a sample size of \eqn{n}  each
test uses \eqn{B \log_2 n} permutations. If \eqn{B+1 < 1/\alpha} then it is not possible to reject
the null hypothesis.}

\item{ties.method}{If "standard" then calculate the p-value as in (5) of \insertCite{BKS2020}{USP},
which is slightly conservative. If "random" then break ties randomly. This preserves Type I error
control.}
}
\value{
Returns an indicator with value 1 if the null hypothesis of independence is rejected and
0 otherwise. If the null hypothesis is rejected, the function also outputs the value of \eqn{M}
at the which the null was rejected and the value of the test statistic.
}
\description{
We implement the adaptive version of the independence test for univariate continuous data
using the Fourier basis, as described in Section 4 of \insertCite{BKS2020}{USP}. This applies
USPFourier with a range of values of \eqn{M}, and a properly corrected significance
level.
}
\examples{
n=100; w=2; x=integer(n); y=integer(n); m=300
unifdata=matrix(runif(2*m,min=0,max=1),ncol=2); x1=unifdata[,1]; y1=unifdata[,2]
unif=runif(m); prob=0.5*(1+sin(2*pi*w*x1)*sin(2*pi*w*y1)); accept=(unif<prob);
Data1=unifdata[accept,]; x=Data1[1:n,1]; y=Data1[1:n,2]
plot(x,y)
USPFourierAdapt(x,y,0.05,999)
}
\references{
\insertRef{BKS2020}{USP}
}
