% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uroot.R
\name{uroot}
\alias{uroot}
\title{Conduct unit root test using \code{EViews} routines}
\usage{
uroot(
  series,
  test = c("adf", "pp"),
  info = "sic",
  caption = NULL,
  format = kable_format(),
  ...
)
}
\arguments{
\item{series}{A vector of names or wildcard expressions for series object(s) contained in a dataframe.}

\item{test}{Name of the unit root test. For example, \code{ADF}, \code{PP}.}

\item{info}{Name of the information criterion. For example, \code{SIC}, \code{AIC}, \code{HQ}.}

\item{caption}{Table caption as in \code{kable}.}

\item{format}{Table format in \code{kable}.}

\item{...}{Other arguments supported by \code{EviewsR} \code{import_kable()} function.}
}
\value{
An EViews workfile
}
\description{
Use this function to conduct unit root test using \code{EViews} routines
}
\examples{
library(URooTab)
\donttest{
set.seed(1234)
x=rnorm(100)
y=cumsum(x)
z=cumsum(y)
dataFrame=data.frame(x,y,z)

# Check if `EViews` is installed before running the tests

eviewsExecutables=c('eviews','eviews10',paste0('Eviews',9:13,'_X',c(86,64)))
if(any(Sys.which(eviewsExecutables)!="")) uroot(series=dataFrame,format="markdown",info="sic")

}
}
\keyword{documentation}
