% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllometricFunctions.R
\name{proportion_silhouette_area_shapes}
\alias{proportion_silhouette_area_shapes}
\title{Organism Silhouette Area using Shape Approximations}
\usage{
proportion_silhouette_area_shapes(shape, theta, h, d)
}
\arguments{
\item{shape}{\code{character} Shape to use to approximate an organism. Shapes are assumed to be prolate or have the longest axis parallel with the ground. Current choices are \code{"spheroid"}, \code{"cylinder flat ends"}, and \code{"cylinder hemisphere ends"}.}

\item{theta}{\code{numeric} angle between the solar beam and the longitudinal axis (degrees).}

\item{h}{\code{numeric} height (long axis in m). Cross section length for spheroid.}

\item{d}{\code{numeric} diameter (short axis in m). Cross section length for spheroid.}
}
\value{
\code{numeric} silhouette area as a proportion.
}
\description{
The function estimates the projected (silhouette) area as a portion of the surface area of the organism. The function estimates the projected area as a function of the dimensions and the angle between the solar beam and the longitudinal axis of the solid, using Figure 11.6 in \insertCite{Campbell1998;textual}{TrenchR}. The function is useful for estimating absorbed solar radiation.
}
\examples{
  proportion_silhouette_area_shapes(shape = "spheroid", 
                                    theta = 60,  
                                    h     = 0.01,  
                                    d     = 0.001)
  proportion_silhouette_area_shapes(shape = "cylinder flat ends",  
                                    theta = 60,  
                                    h     = 0.01, 
                                    d     = 0.001)
  proportion_silhouette_area_shapes(shape = "cylinder hemisphere ends",  
                                    theta = 60,  
                                    h     = 0.01, 
                                    d     = 0.001)

}
\references{
\insertAllCited{}
}
\seealso{
Other allometric functions: 
\code{\link{mass_from_length}()},
\code{\link{proportion_silhouette_area}()},
\code{\link{surface_area_from_length}()},
\code{\link{surface_area_from_mass}()},
\code{\link{surface_area_from_volume}()},
\code{\link{volume_from_length}()}
}
\concept{allometric functions}
