% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TempWindProfileFunctions.R
\name{air_temp_profile_segment}
\alias{air_temp_profile_segment}
\title{Air Temperature at a Specified Height}
\usage{
air_temp_profile_segment(T_r, u_r, zr, z0, z, T_s)
}
\arguments{
\item{T_r}{\code{numeric} a vector of air temperatures (C) at the 3 reference heights.}

\item{u_r}{\code{numeric} a vector of wind speeds (\ifelse{html}{\out{m s<sup>-1</sup>}}{\eqn{m s^-1}{ASCII}}) at the 3 reference heights.}

\item{zr}{\code{numeric} a vector of 3 reference heights (meters).}

\item{z0}{\code{numeric} a vector of 3 experimentally determined roughness heights (meters).}

\item{z}{\code{numeric} height for air temperature estimation (meters).}

\item{T_s}{\code{numeric} surface temperatures (C).}
}
\value{
\code{numeric} air temperature (C).
}
\description{
The function calculates air temperature (C) at a specified height (m). Estimates a three segment velocity and temperature profile based on user-specified, experimentally determined values for 3 roughness heights and reference heights. Multiple heights are appropriate in heterogenous areas with, for example, a meadow, bushes, and rocks. Implements the MICROSEGMT routine from NicheMapR as described in \insertCite{Kearney2017;textual}{TrenchR}.
}
\examples{
  air_temp_profile_segment(T_r = c(25, 22, 20), 
                           u_r = c(0.01, 0.025, 0.05), 
                           zr  = c(0.05, 0.25, 0.5), 
                           z0  = c(0.01, 0.15, 0.2), 
                           z   = 0.3, 
                           T_s = 27)

}
\references{
\insertAllCited{}
}
\seealso{
Other microclimate functions: 
\code{\link{air_temp_profile_neutral}()},
\code{\link{air_temp_profile}()},
\code{\link{degree_days}()},
\code{\link{direct_solar_radiation}()},
\code{\link{diurnal_radiation_variation}()},
\code{\link{diurnal_temp_variation_sineexp}()},
\code{\link{diurnal_temp_variation_sinesqrt}()},
\code{\link{diurnal_temp_variation_sine}()},
\code{\link{monthly_solar_radiation}()},
\code{\link{partition_solar_radiation}()},
\code{\link{proportion_diffuse_solar_radiation}()},
\code{\link{solar_radiation}()},
\code{\link{surface_roughness}()},
\code{\link{wind_speed_profile_neutral}()},
\code{\link{wind_speed_profile_segment}()}
}
\concept{microclimate functions}
