% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrenchR-package.R
\docType{package}
\name{TrenchR-package}
\alias{TrenchR}
\alias{TrenchR-package}
\title{TrenchR: Tools for Microclimate and Biophysical Ecology}
\description{
Tools for translating environmental change into organismal response. Microclimate models to vertically scale weather station data to organismal heights. The biophysical modeling tools include both general models for heat flows and specific models to predict body temperatures for a variety of ectothermic taxa. Additional functions model and temporally partition air and soil temperatures and solar radiation. Utility functions estimate the organismal and environmental parameters needed for biophysical ecology. 'TrenchR' focuses on relatively simple and modular functions so users can create transparent and flexible biophysical models. Many functions are derived from Gates (1980) \doi{10.1007/978-1-4612-6024-0} and Campbell and Norman (1988) <isbn:9780387949376>.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://trenchproject.github.io/TrenchR/}
  \item \url{https://github.com/trenchproject/TrenchR}
  \item Report bugs at \url{https://github.com/trenchproject/TrenchR/issues}
}

}
\author{
\strong{Maintainer}: Lauren Buckley \email{lbuckley@uw.edu} (\href{https://orcid.org/0000-0003-1315-3818}{ORCID})

Authors:
\itemize{
  \item Bryan Briones Ortiz
  \item Isaac Caruso
  \item Aji John (\href{https://orcid.org/0000-0002-4401-1401}{ORCID})
  \item Ofir Levy (\href{https://orcid.org/0000-0003-0920-1207}{ORCID})
  \item Abigail Meyer
  \item Eric Riddell (\href{https://orcid.org/0000-0002-4229-4911}{ORCID})
  \item Yutaro Sakairi
  \item Juniper Simonis (\href{https://orcid.org/0000-0001-9798-0460}{ORCID})
}

Other contributors:
\itemize{
  \item Brian Helmuth (\href{https://orcid.org/0000-0003-0180-3414}{ORCID}) [contributor]
}

}
\keyword{internal}
