% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggCountHeatmap.R
\name{ggDomainLabel}
\alias{ggDomainLabel}
\title{Add a Topological Domain Label to a Count Heatmap}
\usage{
ggDomainLabel(
  td,
  fmt = "\%s: \%.2f - \%.2f Mbp",
  rot = 45,
  dx = 0,
  vjust = 2.5,
  cex = 1.5
)
}
\arguments{
\item{td}{A single-row data.frame.}

\item{fmt}{The \link[base:sprintf]{base::sprintf}-format string taking (chromosome, start, stop) as
(string, numeric, numeric) input.}

\item{rot}{The amount of rotation in [0,360] of label.}

\item{dx, vjust}{The vertical adjustment of the label (relative to rotation)}

\item{cex}{The scale factor of the label.}
}
\value{
A \link[ggplot2:ggproto]{ggplot2::ggproto} object to be added to the count heatmap.
}
\description{
Add a Topological Domain Label to a Count Heatmap
}
