% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/references_to_bibtex.R
\name{references_to_bibtex}
\alias{references_to_bibtex}
\title{Convert references in plain text to BibTeX format}
\usage{
references_to_bibtex(references)
}
\arguments{
\item{references}{A character string or a file path to a file containing the plain text references to convert.}
}
\value{
A character string containing the references in BibTeX format or, if a file path is provided, the function writes the BibTeX entries to a .bib file in the same directory and returns the file path of the newly created .bib file.
}
\description{
This function takes a character string or a file path to plain text references and
converts them into BibTeX format. The function reads the input text, processes it, and
returns a character string containing the references in BibTeX format. If a file path is
provided, the function also writes the BibTeX entries to a .bib file in the same
directory.
}
\examples{
\dontrun{
# Convert plain text references to BibTeX format
references <- "Doe, J., & Smith, J. (2020). The title of the paper.
Journal of Scientific Computing, 12, 45-67."
references_to_bibtex(references)
}
}
\seealso{
\url{https://ctan.org/pkg/bibtex} for more information on BibTeX format
}
\author{
Ulrich Matter umatter@protonmail.com
}
