% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eligibility_functions.R
\name{incrementRho}
\alias{incrementRho}
\title{(Internal) Increment exposure record variable: rho}
\usage{
incrementRho(
  exposure_record,
  segments_to_apply,
  segment_prob,
  eligibility_flag,
  assembly_was_feasible,
  simulation_constants
)
}
\arguments{
\item{exposure_record}{a named list containing exposure records.}

\item{segments_to_apply}{which segments to apply the incrementing.}

\item{segment_prob}{the amount of increment.}

\item{eligibility_flag}{a named list containing eligibility flags.}

\item{assembly_was_feasible}{see \code{\link{assemblyInFinalThetaSegmentWasFeasibleAtLeastOnceInInterimThetaSegments}}.}

\item{simulation_constants}{a named list containing simulation constants.}
}
\value{
\code{\link{incrementRho}} returns an updated exposure record.
}
\description{
\code{\link{incrementRho}} is an internal function for incrementing an exposure record variable.
Specifically, the \code{s_ijk} variable is incremented for accounting for infeasible shadowtests.
}
\keyword{internal}
