% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harsanyidividend.R
\name{harsanyidividend}
\alias{harsanyidividend}
\title{Harsanyi dividend}
\usage{
harsanyidividend(v, S, binary = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{S}{The position of a coalition, as an integer.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} and \code{S} are introduced according to binary order instead of lexicographic order.}
}
\value{
The Harsanyi dividend of the coalition that occupies the given position in the given order.
}
\description{
This function computes the Harsanyi dividend of the given coalition in the given game.
}
\details{
The Harsanyi dividends of \eqn{v\in G^N} are the coordinates of the game in the base of unanimity games.
They are defined, for all \eqn{S\in 2^N}, by
\deqn{c_S=\sum_{S'\subset S}(-1)^{|S|-|S'|}v(S')}.
}
\examples{
n <- 3
v <- c(1, 5, 10, 7, 11, 15, 16) # introduced in lexicographic order

coalitionsvector<-character()
dividendsvector<-numeric()

for (i in 1:(2^n-1)){
  coalitionsvector <- c(coalitionsvector,
                        paste(getcoalition(i)[getcoalition(i) != 0],collapse = " "))
  dividendsvector <- c(dividendsvector,
                       harsanyidividend(v, codelex2bin(n,i), binary = FALSE))
}

data.frame(Coalition = coalitionsvector, Dividend = dividendsvector)
data.frame(Coalition = bin2lex(coalitionsvector), Dividend = bin2lex(dividendsvector))
}
\references{
Hammer, P.J., Peled, U.N., & Sorensen, S. (1977). Pseudo-boolean function and game theory I. Core elements and Shapley value. \emph{Cahiers du Centre d'Etudes de Recherche Opérationnelle}, 19, 156-176.
}
\seealso{
\link{unanimitygame}
}
