% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repr_list.R
\name{repr_list}
\alias{repr_list}
\title{Computation of list of representations list of time series with different lengths}
\usage{
repr_list(
  x,
  func = NULL,
  args = NULL,
  normalise = FALSE,
  func_norm = norm_z,
  windowing = FALSE,
  win_size = NULL
)
}
\arguments{
\item{x}{the list of time series, where time series can have different lengths}

\item{func}{the function that computes representation}

\item{args}{the list of additional (or required) parameters of func (function that computes representation)}

\item{normalise}{normalise (scale) time series before representations computation? (default is FALSE)}

\item{func_norm}{the normalisation function (default is \code{norm_z})}

\item{windowing}{perform windowing? (default is FALSE)}

\item{win_size}{the size of the window}
}
\value{
the numeric list of representations of time series
}
\description{
The \code{repr_list} computes list of representations from list of time series
}
\details{
This function computes representation to an every member of a list of time series (that can have different lengths) and returns list of time series representations.
It can be combined with windowing (see \code{\link{repr_windowing}}) and normalisation of time series.
}
\examples{
# Create random list of time series with different lengths
list_ts <- list(rnorm(sample(8:12, 1)), rnorm(sample(8:12, 1)), rnorm(sample(8:12, 1)))
repr_list(list_ts, func = repr_sma,
 args = list(order = 3))

# return normalised representations, and normalise time series by min-max normalisation
repr_list(list_ts, func = repr_sma,
 args = list(order = 3), normalise = TRUE, func_norm = norm_min_max)

}
\seealso{
\code{\link[TSrepr]{repr_windowing}, \link[TSrepr]{repr_matrix}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
