% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fittestLM.r
\name{fittestLM}
\alias{fittestLM}
\title{Automatically finding fittest linear model for prediction}
\usage{
fittestLM(
  timeseries,
  timeseries.test = NULL,
  h = NULL,
  level = 0.95,
  na.action = stats::na.omit,
  filtered = TRUE,
  order = NULL,
  minorder = 0,
  maxorder = 5,
  raw = FALSE,
  initQ = NULL,
  rank.by = c("MSE", "NMSE", "MAPE", "sMAPE", "MaxError", "AIC", "AICc", "BIC", "logLik",
    "errors", "fitness"),
  ...
)
}
\arguments{
\item{timeseries}{A vector or univariate time series which contains the
values used for fitting the models.}

\item{timeseries.test}{A vector or univariate time series containing a
continuation for \code{timeseries} with actual values. It is used as a
testing set and base for calculation of prediction error measures. Ignored
if \code{NULL}.}

\item{h}{Number of consecutive values of the time series to be predicted. If
\code{h} is \code{NULL}, the number of consecutive values to be predicted is
assumed to be equal to the length of \code{timeseries.test}. Required when
\code{timeseries.test} is \code{NULL}.}

\item{level}{Confidence level for prediction intervals.}

\item{na.action}{A function for treating missing values in \code{timeseries}
and \code{timeseries.test}. The default function is \code{\link[stats]{na.omit}},
which omits any missing values found in \code{timeseries} or
\code{timeseries.test}.}

\item{filtered}{See \code{\link{fittestArimaKF}} and
\code{\link{fittestPolyRKF}}.}

\item{order}{See \code{\link{fittestPolyR}} and
\code{\link{fittestPolyRKF}}.}

\item{minorder}{See \code{\link{fittestPolyR}} and
\code{\link{fittestPolyRKF}}.}

\item{maxorder}{See \code{\link{fittestPolyR}} and
\code{\link{fittestPolyRKF}}.}

\item{raw}{See \code{\link{fittestPolyR}}.}

\item{initQ}{See \code{\link{fittestArimaKF}} and
\code{\link{fittestPolyRKF}}.}

\item{rank.by}{Character string. Criteria used for ranking candidate models.
See 'Details'.}

\item{...}{See \code{\link{fittestArima}} and \code{\link{fittestArimaKF}}.}
}
\value{
A list with components: \item{model}{An object containing the
fittest evaluated linear model. The class of the model object is dependent
on the results of the evaluation (ranking). See \code{\link{fittestArima}},
\code{\link{fittestArimaKF}}, \code{\link{fittestPolyR}} and
\code{\link{fittestPolyRKF}}.} \item{rank}{Data.frame with the fitness
and/or prediction accuracy criteria computed for all models considered,
ranked by \code{rank.by}.} \item{ranked.results}{A list of lists containing
the ranked results of the functions \code{\link{fittestArima}},
\code{\link{fittestArimaKF}}, \code{\link{fittestPolyR}} and
\code{\link{fittestPolyRKF}}. Also ranked by \code{rank.by}.}
}
\description{
The function automatically evaluates and returns the fittest linear model
among ARIMA and polynomial regression, with and without Kalman filtering,
for prediction of a given univariate time series. Wrapper for the
\code{\link{fittestArima}}, \code{\link{fittestArimaKF}},
\code{\link{fittestPolyR}} and \code{\link{fittestPolyRKF}} functions for
automatic time series prediction, whose results are also returned.
}
\details{
The results of the best evaluated models returned by
\code{\link{fittestArima}}, \code{\link{fittestArimaKF}},
\code{\link{fittestPolyR}} and \code{\link{fittestPolyRKF}} are ranked and
the fittest linear model for prediction of the given univariate time series
is selected based on the criteria in \code{rank.by}.

The ranking criteria in \code{rank.by} may be set as a prediction error
measure (such as \code{\link{MSE}}, \code{\link{NMSE}}, \code{\link{MAPE}},
\code{\link{sMAPE}} or \code{\link{MAXError}}), or as a fitness criteria
(such as \code{\link{AIC}}, \code{\link[MuMIn]{AICc}}, \code{\link{BIC}} or
\code{\link{logLik}}). See \code{\link{fittestArima}},
\code{\link{fittestArimaKF}}, \code{\link{fittestPolyR}} or
\code{\link{fittestPolyRKF}}.

If \code{rank.by} is set as \code{"errors"} or \code{"fitness"}, the
candidate models are ranked by all the mentioned prediction error measures
or fitness criteria, respectively. The wheight of the ranking criteria is
equally distributed. In this case, a \code{rank.position.sum} criterion is
produced for ranking the candidate models. The \code{rank.position.sum}
criterion is calculated as the sum of the rank positions of a model (1 = 1st
position = better ranked model, 2 = 2nd position, etc.) on each calculated
ranking criteria.
}
\examples{

\donttest{
data(CATS,CATS.cont)
fittest <- fittestLM(CATS[,1],CATS.cont[,1])

#fittest model information
fittest$rank[1,]

#predictions of the fittest model
fittest$ranked.results[[1]]$pred
}

}
\seealso{
\code{\link{fittestArima}}, \code{\link{fittestArimaKF}},
\code{\link{fittestPolyR}}, \code{\link{fittestPolyRKF}}
}
\author{
Rebecca Pontes Salles
}
\keyword{ARIMA}
\keyword{Kalman}
\keyword{adjustment}
\keyword{automatic}
\keyword{criterion}
\keyword{errors}
\keyword{evaluation}
\keyword{filter}
\keyword{fittest}
\keyword{fitting}
\keyword{linear}
\keyword{model}
\keyword{polynomial}
\keyword{prediction}
\keyword{regression}
