% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSANN.R
\name{Auto.TSANN}
\alias{Auto.TSANN}
\title{Time Series Artificial Neural Network}
\usage{
Auto.TSANN(data, min.size, max.size, split.ratio)
}
\arguments{
\item{data}{Time Series Data}

\item{min.size}{Minimum Size of Hidden Layer}

\item{max.size}{Maximum Size of Hidden Layer}

\item{split.ratio}{Training and Testing Split Ratio}
}
\value{
A list containing:
\itemize{
  \item FinalModel: Best ANN model
  \item Trace: Matrix of All Iteration
  \item FittedValue: Model Fitted Value
  \item PredictedValue: Model Forecast Value of Test Data
  \item Train.RMSE: Root Mean Square Error of Train Data
  \item Test.RMSE: Root Mean Square Error of Test Data
}
}
\description{
The best ANN structure for time series data analysis is a demanding need in the present era. This package will find the best-fitted ANN model based on forecasting accuracy. The optimum size of the hidden layers was also determined after determining the number of lags to be included. This package has been developed using the algorithm of Paul and Garai (2021) <doi:10.1007/s00500-021-06087-4>.
}
\examples{
set.seed(16)
x<-rnorm(n = 50, mean = 150, sd = 10)
Auto.TSANN(x,1,2,0.80)
}
\references{
Paul, R.K. and Garai, S. (2021). Performance comparison of wavelets-based machine learning technique for forecasting agricultural commodity prices, Soft Computing, 25(20), 12857-12873
}
