% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model_tou.R
\name{fit.model.tou}
\alias{fit.model.tou}
\title{Estimation of Transformed Ornstein-Uhlenbeck model for
adsorption kinetics.}
\usage{
fit.model.tou(w, qe = NULL, kn = NULL, n = NULL)
}
\arguments{
\item{w}{a matrix with the observed values. The first column has the
observed times and the following columns have the observed values of the
dependent variable, one column per experimental trajectory.}

\item{qe}{an optional scalar indicating a fixed value for the parameter qe.}

\item{kn}{an optional scalar indicating a fixed value for the parameter kn.}

\item{n}{an optional scalar indicating a fixed value for the parameter n.}
}
\value{
a list with the estimated parameters and the goodness of fit
measures.
}
\description{
This function finds the best values for the parameters of the pseudo-n-order
(PNO) model and its related Transformed Ornstein-Uhlenbeck (TOU) model. It also provides information about
some goodness of fit measures.

This function allows to freely estimate the parameters of the TOU model
by fixing some parameters of the related pseudo-n-order (PNO) model, such as
the maximum adsorption capacity (qe), the adsorption rate constant (kn) and
the order of the model (n).
}
\details{
This package is based on the methodology provided by
\insertCite{rodriguez.2021}{TOU} and it is designed to model the adsorption
kinetics of removal of contaminants such as dyes, metal ions, fluorides,
cyanides, arsenates, arsenites, antibiotics, hormones, etc. from an aqueous
phase by several materials. In this case, the only limiting factor in the
decrease of pollutant concentration is adsorption on the surface of the
adsorbent and does not exclude the existence of intraparticle and film
diffusion phenomena.

This function provides the following parameters: the maximum adsorption (qe),
the value of the fractional-order kinetics (n), the adsorption rate constant
(kn), the parameter related to the reaction order n of the kinect process (a),
rate constant (lambda), the rate constant related to the variance of the
Brownian motion (sigma), the variance of the long term kinetics (tau), the
time needed to reach half of the maximum adsorption (t.half.qe) and the time
needed to reach the maximum adsorption (t.reach.qe). The goodness of fit
measures provided for this function are the loglikelihood of the model
(logLikelihood), the coefficient of determination (R2), the mean squared
error (MSE) and the normalized standard deviation (delta.q).
}
\examples{

# an example with one trajectory of experimental adsorption
observed.time <- c(0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 150, 200,
                   250, 300)
observed.values <- c(0, 1.684, 2.341, 2.581, 2.842, 2.890, 2.959, 3.042,
                     3.083, 3.043, 3.017, 2.954, 2.996, 2.886, 2.844)
observed.process <- cbind(observed.time, observed.values)
# fitting the model without any fixed parameters
result <- fit.model.tou(w=observed.process)
print(result)
# fitting the model with a fixed value for the parameter qe
result <- fit.model.tou(w=observed.process, qe=2.9)
print(result)
# fitting the model with fixed values for the parameters qe and n
result <- fit.model.tou(w=observed.process, qe=2.9, n=1.2)
print(result)

# an example with three trajectories of experimental adsorption
observed.time <- c(0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 150, 200,
                   250, 300)
observed.values.1 <- c(0, 1.684, 2.341, 2.581, 2.842, 2.890, 2.959, 3.042,
                       3.083, 3.043, 3.017, 2.954, 2.996, 2.886, 2.844)
observed.values.2 <- c(0, 1.618, 2.217, 2.571, 2.763, 2.841, 2.866, 2.898,
                       2.935, 2.973, 2.906, 2.919, 2.910, 3.012, 3.071)
observed.values.3 <- c(0, 1.596, 2.333, 2.611, 2.750, 2.731, 2.829, 2.838,
                       2.864, 2.884, 2.886, 2.911, 2.896, 2.877, 2.969)
observed.processes <- cbind(observed.time, observed.values.1,
                            observed.values.2, observed.values.3)
# fitting the model with a fixed value for the parameter n
result <- fit.model.tou(w=observed.processes, n=1.21)
print(result)
# fitting the model with fixed values for the parameters qe, kn and n
result <- fit.model.tou(w=observed.processes, qe=2.95, kn=0.07, n=1.21)
print(result)

}
\references{
\insertRef{rodriguez.2021}{TOU}
}
