% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LICnew.R
\name{LICnew}
\alias{LICnew}
\title{Calculate the LIC estimator based on A-optimal and D-optimal criterion}
\usage{
LICnew(X, Y, alpha, K, nk)
}
\arguments{
\item{X}{A matrix of observations (design matrix) with size n x p}

\item{Y}{A vector of responses with length n}

\item{alpha}{The significance level for confidence intervals}

\item{K}{The number of subsets to consider}

\item{nk}{The size of each subset}
}
\value{
A list containing:
\item{E5}{The LIC estimator based on A-optimal and D-optimal criterion.}
}
\description{
Calculate the LIC estimator based on A-optimal and D-optimal criterion
}
\examples{
p = 6; n = 1000; K = 2; nk = 200; alpha = 0.05; sigma = 1
e = rnorm(n, 0, sigma); beta = c(sort(c(runif(p, 0, 1))));
data = c(rnorm(n * p, 5, 10)); X = matrix(data, ncol = p);
Y = X \%*\% beta + e;
LICnew(X = X, Y = Y, alpha = alpha, K = K, nk = nk)
}
\references{
Guo, G., Song, H. & Zhu, L. The COR criterion for optimal subset selection in distributed estimation. \emph{Statistics and Computing}, 34, 163 (2024). \doi{10.1007/s11222-024-10471-z}
}
