% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf.R
\name{dTLCAR}
\alias{dTLCAR}
\title{Probability Density Function (PDF) for the TLCAR Distribution}
\usage{
dTLCAR(x, alpha, a, b, theta, m)
}
\arguments{
\item{x}{Value at which to calculate the PDF.}

\item{alpha}{Parameter representing the distribution of the Topp-Leone component.}

\item{a}{Parameter representing the scale (a) of the Cauchy component.}

\item{b}{Parameter representing the position (b) of the Cauchy component.}

\item{theta}{Parameter representing the scale of the Rayleigh component.}

\item{m}{Additional parameter.}
}
\value{
Probability density at the given value.
}
\description{
Calculate the probability density at a given value using the TLCAR distribution.
}
\details{
The probability density function (PDF) for the TLCAR distribution is defined as follows:
\deqn{f(x)=\frac{2\alpha}{\pi a}\left[\frac{1+\left(\frac{x^2}{\theta^2}-1\right)e^{-\frac{x^2}{2\theta^2}}+m}{1+\left(\frac{x\left(1-e^{-\frac{x^2}{2\theta^2}}+m\right) -b}{a}\right)^2}\right]\left[\frac{1}{2}-\frac{1}{\pi}\arctan\frac{x\left(1-e^{-\frac{x^2}{2\theta^2}}+m\right) -b}{a}\right]\left[ 1-\left(\frac{1}{2}-\frac{1}{\pi}\arctan\frac{x\left(1-e^{-\frac{x^2}{2\theta^2}}+m\right)-b}{a}\right)^2\right]^{\alpha-1}}
}
\examples{
dTLCAR(x = 1, alpha = 1, a = 1, b = 0, theta = 2, m = 0.5)

}
