ind_test <- function(X, n.rep = 200, score = "Identity", weight = "Gauss", strategy = "bootstrap", 
                     ncores = NULL, iseed = NULL) {
  
  DNAME <- deparse(substitute(X))
  
  # Validate and match arguments
  score <- match.arg(score, c("Identity", "Ranks", "VDW"))
  weight <- match.arg(weight, c("Gauss", "Laplace"))
  strategy <- match.arg(strategy, c("bootstrap", "permutation"))
  
  # Construct a key to use in the switch statement based on strategy
  method_id <- paste(score, weight, strategy, sep = "_")
  
  # Use switch to select and execute the appropriate function directly
  result <- switch(method_id,
                   "Identity_Gauss_bootstrap" = ICAtestGauss_S_par(X, n.rep, ncores, iseed),
                   "Identity_Laplace_bootstrap" = ICAtestLap_S_par(X, n.rep, ncores, iseed),
                   "Ranks_Gauss_bootstrap" = ICAtestRankGauss_S_par(X, n.rep, ncores, iseed),
                   "Ranks_Laplace_bootstrap" = ICAtestRankLap_S_par(X, n.rep, ncores, iseed),
                   "VDW_Gauss_bootstrap" = ICAtestRankvdW_S_par(X, n.rep, ncores, iseed),
                   "Identity_Gauss_permutation" = ICAtestGauss_S_perm_par(X, n.rep, ncores, iseed),
                   "Identity_Laplace_permutation" = ICAtestLap_S_perm_par(X, n.rep, ncores, iseed),
                   "Ranks_Gauss_permutation" = ICAtestRankGauss_S_perm_par(X, n.rep, ncores, iseed),
                   "Ranks_Laplace_permutation" = ICAtestRankLap_S_perm_par(X, n.rep, ncores, iseed),
                   "VDW_Gauss_permutation" = ICAtestRankvdW_S_perm_par(X, n.rep, ncores, iseed)
  )
  
  # Constructing output
  METHOD <- sprintf("Test for complete independence using %s score, %s weight and %s strategy.", 
                    score, weight, strategy)
  ALTERNATIVE <- "not all variables are independent"
  
  PARAMETER <- n.rep
  names(PARAMETER) <- ifelse(strategy == "bootstrap", "replications", "permutations")
  
  # Enhance the output list to conform to 'htest' class
  RES <- list(
    statistic = c(T = result$T),
    p.value = result$pval,
    method = METHOD,
    data.name = DNAME,
    alternative = ALTERNATIVE,
    parameter = PARAMETER,
    score = score,
    weight = weight,
    strategy = strategy
  )
  class(RES) <- "htest"
  
  return(RES)
}
