% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{plot_transaction_dataset}
\alias{plot_transaction_dataset}
\title{Plot of Cumulative Claims Payments (Incurred Pattern)}
\usage{
plot_transaction_dataset(
  transactions,
  occurrence_time_col = "occurrence_time",
  payment_time_col = "payment_time",
  payment_size_col = "payment_inflated",
  by_year = FALSE,
  adjust = TRUE
)
}
\arguments{
\item{transactions}{a dataset of partial payment records.}

\item{occurrence_time_col}{name of column that stores the time of occurrence
of the claims (on a \strong{continuous} scale).}

\item{payment_time_col}{name of column that stores the time of partial
payments of the claims (on a \strong{continuous} scale).}

\item{payment_size_col}{name of column that stores the size of partial
payments of the claims.}

\item{by_year}{if \code{TRUE} returns a plot by occurrence year; otherwise returns
a plot by occurrence period (default).}

\item{adjust}{if \code{TRUE} then the payment times will be forced to match with
the maximum development period under consideration, otherwise the plot will
see claims beyond the maximum development period; default \code{TRUE}.}
}
\description{
Generates a plot of cumulative claims paid (as a percentage of total amount
incurred) as a function of development time for each occurrence period.
}
\examples{
plot_transaction_dataset(test_transaction_dataset)

# Plot claim development without end-of-development-period correction
plot_transaction_dataset(test_transaction_dataset, adjust = FALSE)

# Plot claim development without inflation effects
plot_transaction_dataset(test_transaction_dataset, payment_size_col = "payment_size")
}
\seealso{
\code{\link{generate_transaction_dataset}}
}
