% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.haz.R
\name{add.haz}
\alias{add.haz}
\title{Additive hazards model with sparse longitudinal covariates}
\usage{
add.haz(data, n, tau, h, method)
}
\arguments{
\item{data}{An object of class tibble. The structure of the tibble must be: tibble(id = id, X = failure time, covariates = observation for covariates, obs_times = observation times, delta = censoring indicator).}

\item{n}{An object of class integer. The sample size.}

\item{tau}{An object of class numeric. The pre-specified time endpoint.}

\item{h}{An object of class vector. If use auto bandwidth selection, the structure of the vector must be: h = c(the maximum bandwidth, the minimum bandwidth, the number of bandwidth divided). If use fixed bandwidth, h is the chosen bandwidth.}

\item{method}{An object of class integer. If use weighted LVCF, method = 1. If use half kernel, method = 2. If use full kernel, method = 3.}
}
\value{
a list with the following elements:
\item{est}{The estimation for the corresponding parameters.}
\item{se}{The estimation for the standard error of the estimated parameters.}
}
\description{
Regression analysis of additive hazards model with sparse longitudinal covariates. Three different weighting schemes are provided to impute the missing values.
}
\examples{

library(gaussquad)
library(dplyr)
library(nleqslv)
library(MASS)
n=500
lqrule64 <- legendre.quadrature.rules(64)[[64]]
simdata <- function(alpha,beta ) {
cen=1
nstep=20
Sigmat_z <- exp(-abs(outer(1:nstep, 1:nstep, "-")) / nstep)
z  <-   c(mvrnorm(  1, c(1: nstep)/2, Sigmat_z  ))
left_time_points <- (0:(nstep - 1)) / nstep
z_fun <- stepfun(left_time_points, c(0,z  ))
lam_fun <- function(tt) {  alpha(tt)+beta*z_fun(tt)}
u <- runif(1)
fail_time <- nleqslv( 0 , function(ttt)
 legendre.quadrature(lam_fun,
                   lower = 0,
                   upper = ttt,
                   lqrule64) + log(u))$x

X <- min(fail_time, cen)
obs=rpois(1,5)+1
tt= sort(runif(obs, min = 0, max = 1))
obs_times <- tt[which(tt<=cen)]
if (length(obs_times) == 0)
 obs_times <- cen
 covariates_obscov <-z_fun(obs_times)
 return( tibble(X = X,delta = fail_time < cen,
 covariates = covariates_obscov,obs_times = obs_times, censoring = cen  )  ) }
data <- replicate(n, simdata(alpha = function(tt)  tt, 1  ),
              simplify = FALSE ) \%>\% bind_rows(.id = "id")

add.haz(data,n,1,n^(-0.5),3)
}
\references{
Sun, Z. et al. (2022) <doi:10.1007/s10985-022-09548-6>
}
