% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\encoding{UTF-8}
\name{vDBS}
\alias{vDBS}
\title{Variance Estimation for Doubly Balanced Sample.}
\usage{
vDBS(Xauxs, Xspreads, piks, ys)
}
\arguments{
\item{Xauxs}{A matrix of size (\eqn{n} x \eqn{p}) of auxiliary variables on which the sample must be balanced.}

\item{Xspreads}{Matrix of spatial coordinates.}

\item{piks}{A vector of inclusion probabilities. The vector has the size \eqn{n} of the sample \eqn{s}.}

\item{ys}{A variable of interest. The vector has the size \eqn{n} of the sample \eqn{s}.}
}
\value{
Estimated variance of the horvitz-thompson estimator.
}
\description{
Variance estimator for sample that are at the same time well spread and balanced on auxiliary variables. See Grafstr\"om and Till\'e (2013)
}
\examples{

N <- 100 
n <- 40
x1 <- rgamma(N,4,25)
x2 <- rgamma(N,4,25)

pik <- rep(n/N,N)
Xaux <- cbind(pik,as.matrix(matrix(c(x1,x2),ncol = 2)))
Xspread <- cbind(runif(N),runif(N))
  

s <- balseq(pik,Xaux,Xspread)
  
y <- Xaux\%*\%c(1,1,3) + rnorm(N,120) # variable of interest
  
vEst(Xaux[s,],pik[s],y[s])
vDBS(Xaux[s,],Xspread[s,],pik[s],y[s])
vApp(Xaux,pik,y)

}
\references{
Grafstr\"om, A. and Till\'e, Y. (2013), Doubly balanced spatial sampling with spreading and restitution of auxiliary totals, Environmetrics, 14(2):120-131
}
\seealso{
\code{\link{vDBS}} \code{\link{vApp}}
}
