% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_methods-PERFORMANCE.R
\docType{methods}
\name{compare}
\alias{compare}
\alias{compare,Strategy-method}
\title{Compare performance of \code{Strategy}-objects.}
\usage{
compare(..., from=NULL, until=NULL, which=NULL
       , scaling.periods=NULL, include.costs=TRUE
       , use.backtest=FALSE, include.params=FALSE)

\S4method{compare}{Strategy}(..., from = NULL, until = NULL, which = NULL,
  scaling.periods = NULL, include.costs = TRUE, use.backtest = FALSE,
  include.params = FALSE)
}
\arguments{
\item{...}{Objects of class \code{Strategy}.}

\item{from}{The date in character format \code{"yyyy-MM-dd"} or as date-object from which performance shall be considered. If \code{NULL}, no restriction is made.}

\item{until}{The date in character format \code{"yyyy-MM-dd"} or as date-object until which performance shall be considered. If \code{NULL}, no restriction is made.}

\item{which}{Names or number of assets that should be included in calculation.}

\item{scaling.periods}{Vector with annualization factors for calculation. Default is 252, 52, 12, 4, 1 for daily, weekly, monthly, quarterly and yearly data respectively.}

\item{include.costs}{If \code{FALSE}, the fixed and relative trading costs are NOT considered for performance calculation. Default value is \code{TRUE}. As default values for costs are \code{0}, this argument is obsolete if no costs are given.}

\item{use.backtest}{If \code{TRUE}, the performance of the backtesting output is considered for performance indicator calculation. If \code{FALSE}, the performance of the initial strategy execution are used.}

\item{include.params}{If \code{TRUE} the parameters of the strategies are included in their names. E.g. \code{MA(k=200)} instead of \code{MA} as strategy name for moving average.}
}
\description{
Compare the portfolio performance indicators of an arbitrary number of objects of class \code{Strategy}.
}
\examples{
##Not run:

# MA(200)-Strategy
params <- list(k=200)
myStrat.MA <- Strategy(assets=assets, strat="MA", strat.params=params)

# EWMA(0.05)-Strategy
params <- list(lambda=0.05)
myStrat.EWMA <- Strategy(assets=assets, strat="EWMA", strat.params=params)

# Compare annualized performance of MA(200) and EWMA(0.05)
# compare(myStrat.MA, myStrat.EWMA, use.backtest=TRUE, scaling.periods=252)

##End(Not run)
}
