% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphing_functions.R
\name{plotDeltaHistogram}
\alias{plotDeltaHistogram}
\title{Plot Delta Frequency Histogram}
\usage{
plotDeltaHistogram(
  data_path,
  graph_title = "Delta Frequency-Labeled Histogram",
  graph_subtitle = "Delta Frequency measures the kHz range of each detected call."
)
}
\arguments{
\item{data_path}{The full path to the Excel file exported from DeepSqueak}

\item{graph_title}{The title for the graph (there is a default title if not specified)}

\item{graph_subtitle}{The subtitle for the graph (there is a default subtitle if not specified)}
}
\value{
A ggplot2 visualization of the histogram shown in the viewer window, which can be manually exported.
}
\description{
Plots a distribution of delta frequencies as a histogram.
}
\examples{
\dontrun{plotDeltaHistogram(
  data_path = "inst/extdata/Example_Mouse_Data.xlsx",
  graph_title = "myTitle", graph_subtitle = "myDescription"
)}

}
