% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_border.R
\name{shift_border}
\alias{shift_border}
\title{Shift, shrink/grow, and rotate borders around}
\usage{
shift_border(
  border,
  operation = c("shift", "scale", "rotate"),
  shift = c(0, 0),
  scale = 1,
  angle = 0
)
}
\arguments{
\item{border}{sf object with line geometry}

\item{operation}{\code{"shift"}, \code{"rotate"}, \code{"scale"} - or a combination of them}

\item{shift}{if \code{operation = "shift"}, shift distance in CRS units (if UTM it is metres) for x and y coordinates as \code{c(dist_x, dist_y)}}

\item{scale}{if \code{operation = "scale"}, provide shrinkage/growth factor: e.g. \code{.9} to shrink by 10perc. and \code{1.1} to increase by 10perc.}

\item{angle}{if \code{operation = "rotate"}, provide angle in degrees}
}
\value{
a new border in the form of an sf object
}
\description{
This functions takes in a border and can either shift, shrink, or rotate it. All of them can be done together as well.
This usually takes a bit of trial and error, so make sure to plot the result each time.
For a detailed walk through check out the according vignette: \code{vignette(shifting_borders)}.
}
\examples{
shift_border(border = cut_off, operation = c("shift", "scale"),
shift = c(-5000, -3000), scale = .85)

shift_border(border = cut_off, operation = "rotate", angle = 10)


}
