% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatPCA.R
\name{spatpcaCVWithSelectedK}
\alias{spatpcaCVWithSelectedK}
\title{Internal function: M-fold CV of SpatPCA with selected K}
\usage{
spatpcaCVWithSelectedK(
  x,
  Y,
  M,
  tau1,
  tau2,
  gamma,
  shuffle_split,
  maxit,
  thr,
  l2
)
}
\arguments{
\item{x}{Location matrix}

\item{Y}{Data matrix}

\item{M}{The number of folds for cross validation; default is 5.}

\item{tau1}{Vector of a non-negative smoothness parameter sequence. If NULL, 10 tau1 values in a range are used.}

\item{tau2}{Vector of a non-negative sparseness parameter sequence. If NULL, none of tau2 is used.}

\item{gamma}{Vector of a non-negative hyper parameter sequence for tuning eigenvalues. If NULL, 10 values in a range are used.}

\item{shuffle_split}{Vector of indices for random splitting Y into training and test sets}

\item{maxit}{Maximum number of iterations. Default value is 100.}

\item{thr}{Threshold for convergence. Default value is \eqn{10^{-4}}.}

\item{l2}{Vector of a non-negative tuning parameter sequence for ADMM use}
}
\value{
A list of objects including
\item{cv_result}{A list of resultant objects produced by \code{spatpcaCV}}
\item{selected_K}{Selected K based on CV.}
}
\description{
Internal function: M-fold CV of SpatPCA with selected K
}
\keyword{internal}
