% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparseFunClust_data_generation.R
\name{generate.data.FV17}
\alias{generate.data.FV17}
\title{Data generation: no-misalignment case}
\usage{
generate.data.FV17(n, x, paramC = 0.5, plots = FALSE)
}
\arguments{
\item{n}{number of curves}

\item{x}{curves' domain}

\item{paramC}{proportion of cluster overlap (default 0.5, as in Simulation 2A)}

\item{plots}{boolean; should plots be drawn (\code{FALSE} default)}
}
\value{
a list including:
\itemize{
\item{\code{$data} matrix (n x \code{length(x)}) with the simulated data}
\item{\code{$true.partition} vector (length = n) with the true cluster assignments}
}
}
\description{
this function generates a set of simulated functional data in
2 clusters that reproduce the examples in Simulations 2A and 2B in
Floriello & Vitelli (2017).
}
\examples{
generate.data.FV17(5, seq(0, 1, len = 3))
}
