% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spader.R
\name{ChaoSpecies}
\alias{ChaoSpecies}
\title{Estimation of species richness in a community}
\usage{
ChaoSpecies(data, datatype = c("abundance", "abundance_freq_count",
  "incidence_freq", "incidence_freq_count", "incidence_raw"), k = 10,
  conf = 0.95)
}
\arguments{
\item{data}{a matrix/data.frame of species abundances/incidences.\cr}

\item{datatype}{type of input data, "abundance", "abundance_freq_count", "incidence_freq", "incidence_freq_count" or "incidence_raw". \cr}

\item{k}{the cut-off point (default = 10), which separates species into "abundant" and "rare" groups for abundance data for the estimator ACE; it separates species into "frequent" and
"infrequent" groups for incidence data for the estimator ICE.}

\item{conf}{a positive number \eqn{\le} 1 specifying the level of confidence interval.}
}
\value{
a list of three objects: \cr\cr
\code{$Basic_data_information} and \code{$Rare_species_group}/\code{$Infreq_species_group} for summarizing data information. \cr\cr
\code{$Species_table} for showing a table of various species richness estimates, standard errors, and the associated confidence intervals. \cr\cr
}
\description{
\code{ChaoSpecies}: Estimation of species richness in a single community based on five types of data:
Type (1) abundance data (datatype="abundance"), Type (1A) abundance-frequency counts \cr
(datatype="abundance_freq_count"), Type (2) incidence-frequency data (datatype =
"incidence_freq"), Type (2A) incidence-frequency counts (datatype="incidence_freq_count"), and
Type (2B) incidence-raw data (datatype="incidence_raw"); see \code{SpadeR-package} details for data input formats.
}
\examples{
data(ChaoSpeciesData)
# Type (1) abundance data
ChaoSpecies(ChaoSpeciesData$Abu,"abundance",k=10,conf=0.95)
# Type (1A) abundance-frequency counts data
ChaoSpecies(ChaoSpeciesData$Abu_count,"abundance_freq_count",k=10,conf=0.95)
# Type (2) incidence-frequency data
ChaoSpecies(ChaoSpeciesData$Inci,"incidence_freq",k=10,conf=0.95)
# Type (2A) incidence-frequency counts data
ChaoSpecies(ChaoSpeciesData$Inci_count,"incidence_freq_count",k=10,conf=0.95)
# Type (2B) incidence-raw data 
ChaoSpecies(ChaoSpeciesData$Inci_raw,"incidence_raw",k=10,conf=0.95)
}
\references{
Chao, A., and Chiu, C. H. (2012). Estimation of species richness and shared species richness. In N. Balakrishnan (ed). Methods and Applications of Statistics in the Atmospheric and Earth Sciences. p.76-111, Wiley, New York.\cr\cr
Chao, A., and Chiu, C. H. (2016). Nonparametric estimation and comparison of species richness. Wiley Online Reference in the Life Science. In: eLS. John Wiley and Sons, Ltd: Chichester. DOI: 10.1002/9780470015902.a0026329.\cr\cr
Chao, A., and Chiu, C. H. (2016). Species richness: estimation and comparison. Wiley StatsRef: Statistics Reference Online. 1-26.\cr\cr
Chiu, C. H., Wang Y. T., Walther B. A. and Chao A. (2014). An improved non-parametric lower bound of species richness via the Good-Turing frequency formulas. Biometrics, 70, 671-682. \cr\cr
Gotelli, N. G. and Chao, A. (2013). Measuring and estimating species richness, species diver- sity, and biotic similarity from sampling data. Encyclopedia of Biodiversity, 2nd Edition, Vol. 5, 195-211, Waltham, MA. \cr\cr
}

