% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIP_Functions.R
\name{enhance_actigraph}
\alias{enhance_actigraph}
\title{Combine ActiGraph and activPAL data}
\usage{
enhance_actigraph(ag, ap, verbose = FALSE)
}
\arguments{
\item{ag}{ActiGraph data}

\item{ap}{activPAL data}

\item{verbose}{logical. Print information to console?}
}
\value{
data frame of combined ActiGraph and activPAL data
}
\description{
Merge data streams for separate monitors in the
\href{https://pubmed.ncbi.nlm.nih.gov/27015380/}{SIP method}
}
\examples{
data(SIP_ag, package = "Sojourn")
data(SIP_ap, package = "Sojourn")
combined_data <- enhance_actigraph(SIP_ag, SIP_ap)
utils::head(combined_data)
}
