% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_features_15min.R
\name{calc_features15_consumption}
\alias{calc_features15_consumption}
\title{Calculates features from 15-min smart meter data}
\usage{
calc_features15_consumption(
  B,
  rowname = NULL,
  featsCoarserGranularity = FALSE,
  replace_NA_with_defaults = TRUE
)
}
\arguments{
\item{B}{a vector with length 4*24*7 = 672 measurements in one day in seven days a week}

\item{rowname}{the row name of the resulting feature vector}

\item{featsCoarserGranularity}{are the features of finer granularity levels also to be calculated (TRUE/FALSE)}

\item{replace_NA_with_defaults}{replaces missing (NA) or infinite values that may appear during calculation
with default values}
}
\value{
a data.frame with the calculated features as columns and a specified
   rowname, if given
}
\description{
Calculates features from 15-min smart meter data
}
\examples{
# Create a random time series of 15-minute smart meter data (672 measurements per week)
smd <- runif(n=672, min=0, max=2)
# Calculate the smart meter data features
calc_features15_consumption(smd)

}
\references{
Hopf, K. (2019). Predictive Analytics for Energy Efficiency and
    Energy Retailing (1st ed.). Bamberg: University of Bamberg.
    \doi{10.20378/irbo-54833}

Hopf, K., Sodenkamp, M., Kozlovskiy, I., & Staake, T. (2014).
    Feature extraction and filtering for household classification based on
    smart electricity meter data. Computer Science-Research and Development,
    (31) 3, 141–148. \doi{10.1007/s00450-014-0294-4}

Hopf, K., Sodenkamp, M., & Staake, T. (2018). Enhancing energy
    efficiency in the residential sector with smart meter data analytics.
    Electronic Markets, 28(4). \doi{10.1007/s12525-018-0290-9}
}
\author{
Konstantin Hopf \email{konstantin.hopf@uni-bamberg.de}
}
