% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_survey.R
\name{sim_logistic}
\alias{sim_logistic}
\title{Closure for simulating logistic curve}
\usage{
sim_logistic(k = 2, x0 = 3, plot = FALSE)
}
\arguments{
\item{k}{Steepness of the curve.}

\item{x0}{The x-value at the midpoint of the sigmoid.}

\item{plot}{Logical. Should the relationship be plotted?}
}
\value{
A function that can be passed to \code{\link[=sim_survey]{sim_survey()}}.
}
\description{
This closure is useful for simulating catchability (\code{q}) inside the \code{\link[=sim_survey]{sim_survey()}} function.
}
\examples{
logistic_fun <- sim_logistic(k = 2, x0 = 3, plot = TRUE)
logistic_fun(x = 1:10)

}
