% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_mixmoments.R
\name{calc_mixmoments}
\alias{calc_mixmoments}
\title{Find Standardized Cumulants of a Continuous Mixture Distribution by Method of Moments}
\usage{
calc_mixmoments(mix_pis = NULL, mix_mus = NULL, mix_sigmas = NULL,
  mix_skews = NULL, mix_skurts = NULL, mix_fifths = NULL,
  mix_sixths = NULL)
}
\arguments{
\item{mix_pis}{a vector of mixing probabilities that sum to 1 for the component distributions}

\item{mix_mus}{a vector of means for the component distributions}

\item{mix_sigmas}{a vector of standard deviations for the component distributions}

\item{mix_skews}{a vector of skew values for the component distributions}

\item{mix_skurts}{a vector of standardized kurtoses for the component distributions}

\item{mix_fifths}{a vector of standardized fifth cumulants for the component distributions; keep NULL if using \code{method} = "Fleishman"
to generate continuous variables}

\item{mix_sixths}{a vector of standardized sixth cumulants for the component distributions; keep NULL if using \code{method} = "Fleishman"
to generate continuous variables}
}
\value{
A vector of the mean, standard deviation, skewness, standardized kurtosis, and standardized fifth and sixth cumulants
}
\description{
This function uses the method of moments to calculate the expected mean, standard deviation, skewness,
    standardized kurtosis, and standardized fifth and sixth cumulants for a continuous mixture variable based on the distributions
    of its components.  The result can be used as input to \code{\link[SimMultiCorrData]{find_constants}} or for comparison to a
    simulated mixture variable from \code{\link[SimCorrMix]{contmixvar1}}, \code{\link[SimCorrMix]{corrvar}}, or
    \code{\link[SimCorrMix]{corrvar2}}.  See the \bold{Expected Cumulants and Correlations for Continuous Mixture Variables} vignette
    for equations of the cumulants.
}
\examples{
# Mixture of Normal(-2, 1) and Normal(2, 1)
calc_mixmoments(mix_pis = c(0.4, 0.6), mix_mus = c(-2, 2),
  mix_sigmas = c(1, 1), mix_skews = c(0, 0), mix_skurts = c(0, 0),
  mix_fifths = c(0, 0), mix_sixths = c(0, 0))

}
\references{
Please see references for \code{\link[SimCorrMix]{SimCorrMix}}.
}
\keyword{cumulants}
\keyword{mixture}
