% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSilhouette.R
\name{getSilhouette}
\alias{getSilhouette}
\title{Create Silhouette Object from User Components}
\usage{
getSilhouette(
  cluster,
  neighbor,
  sil_width,
  weight = NULL,
  proximity_type = c("dissimilarity", "similarity"),
  method = NA,
  average = c("crisp", "fuzzy", "median")
)
}
\arguments{
\item{cluster}{Numeric or integer vector of cluster assignments for each observation}

\item{neighbor}{Numeric or integer vector of nearest neighbor cluster assignments for each observation}

\item{sil_width}{Numeric vector of silhouette widths for each observation (must be between -1 and +1)}

\item{weight}{Numeric vector of weights for each observation (must be between 0 and 1, only used when average = "fuzzy")}

\item{proximity_type}{Character; the proximity type used. Options: "similarity" or "dissimilarity"}

\item{method}{Character; the silhouette calculation method used (default: NULL, can be any custom name)}

\item{average}{Character; the averaging method. Options: "crisp", "fuzzy", or "median"}
}
\value{
A data frame of class \code{"Silhouette"} containing cluster assignments, nearest neighbor clusters, silhouette widths for each observation, and weights (for fuzzy clustering). The object includes the following attributes:
\describe{
\item{proximity_type}{The proximity type used (\code{"similarity"} or \code{"dissimilarity"}).}
\item{method}{The silhouette calculation method used (\code{"medoid"} or \code{"pac"}).}
\item{average}{Character — the averaging method: \code{"crisp"}, \code{"fuzzy"}, or \code{"median"}.}
}
}
\description{
Constructs a Silhouette class object directly from user-provided components
without performing silhouette calculations. This function allows users to
build a Silhouette object when they already have the necessary components.
}
\examples{
# Create a simple crisp Silhouette object (3 columns)
cluster_assignments <- c(1, 1, 2, 2, 3, 3)
neighbor_clusters <- c(2, 2, 1, 1, 1, 1)
silhouette_widths <- c(0.8, 0.7, 0.6, 0.9, 0.5, 0.4)

sil_obj <- getSilhouette(
  cluster = cluster_assignments,
  neighbor = neighbor_clusters,
  sil_width = silhouette_widths,
  proximity_type = "dissimilarity",
  method = "medoid",
  average = "crisp"
)
sil_obj

# Create a fuzzy Silhouette object with weights (4 columns)
weights <- c(0.9, 0.8, 0.7, 0.95, 0.6, 0.5)

sil_fuzzy <- getSilhouette(
  cluster = cluster_assignments,
  neighbor = neighbor_clusters,
  sil_width = silhouette_widths,
  weight = weights,
  proximity_type = "similarity",
  method = "pac",
  average = "fuzzy"
)
sil_fuzzy

# Custom method name
sil_custom <- getSilhouette(
  cluster = cluster_assignments,
  neighbor = neighbor_clusters,
  sil_width = silhouette_widths,
  proximity_type = "dissimilarity",
  method = "my_custom_method",
  average = "crisp"
)
sil_custom
}
\seealso{
\code{\link{Silhouette}}, \code{\link{softSilhouette}}, \code{\link{dbSilhouette}}, \code{\link{cerSilhouette}}, \code{\link{is.Silhouette}}, \code{\link{plotSilhouette}}
}
