% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantification.R
\name{GenomeBinMatrix}
\alias{GenomeBinMatrix}
\title{Genome bin matrix}
\usage{
GenomeBinMatrix(
  fragments,
  genome,
  cells = NULL,
  binsize = 5000,
  process_n = 2000,
  sep = c("-", "-"),
  verbose = TRUE
)
}
\arguments{
\item{fragments}{Path to tabix-indexed fragments file or a list of
\code{\link{Fragment}} objects}

\item{genome}{A vector of chromosome sizes for the genome. This is used to
construct the genome bin coordinates. The can be obtained by calling
\code{seqlengths} on a
\code{\link[BSgenome]{BSgenome-class}} object.}

\item{cells}{Vector of cells to include. If NULL, include all cells found
in the fragments file}

\item{binsize}{Size of the genome bins to use}

\item{process_n}{Number of regions to load into memory at a time, per thread.
Processing more regions at once can be faster but uses more memory.}

\item{sep}{Vector of separators to use for genomic string. First element is
used to separate chromosome and coordinates, second separator is used to
separate start and end coordinates.}

\item{verbose}{Display messages}
}
\value{
Returns a sparse matrix
}
\description{
Construct a bin x cell matrix from a fragments file.
}
\details{
This function bins the genome and calls \code{\link{FeatureMatrix}} to
construct a bin x cell matrix.
}
\examples{
\donttest{
genome <- 780007
names(genome) <- 'chr1'
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
fragments <- CreateFragmentObject(fpath)
GenomeBinMatrix(
  fragments = fragments,
  genome = genome,
  binsize = 1000
)
}
}
\concept{quantification}
