% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrinkcovmat.equal.R
\name{shrinkcovmat.equal-deprecated}
\alias{shrinkcovmat.equal-deprecated}
\title{Shrinking the Sample Covariance Matrix Towards a Sphericity Matrix}
\usage{
shrinkcovmat.equal(data, centered)
}
\arguments{
\item{data}{a numeric matrix containing the data.}

\item{centered}{a logical indicating if the mean vector is the zero vector.}
}
\value{
Returns an object of the class 'shrinkcovmathat' that has
components: \item{SigmaHat}{The Stein-type shrinkage estimator of the
covariance matrix.} \item{lambdahat}{The estimated optimal shrinkage
intensity.} \item{sigmasample}{The sample covariance matrix.}
\item{Target}{The target covariance matrix.} \item{centered}{If the data are
centered around their mean vector.}
}
\description{
Provides a nonparametric Stein-type shrinkage estimator of the covariance
matrix that is a linear combination of the sample covariance matrix and of a
diagonal matrix with the average of the sample variances on the diagonal and
zeros elsewhere.
}
\details{
The rows of the data matrix \code{data} correspond to variables and the
columns to subjects.
}
\references{
Touloumis, A. (2015) nonparametric Stein-type Shrinkage
Covariance Matrix Estimators in High-Dimensional Settings.
\emph{Computational Statistics & Data Analysis} \bold{83}, 251--261.
}
\seealso{
\code{\link{shrinkcovmat.unequal}} and
\code{\link{shrinkcovmat.identity}}.

\code{\link{ShrinkCovMat-deprecated}}
}
\author{
Anestis Touloumis
}
\keyword{internal}
