% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{read_luminex_data}
\alias{read_luminex_data}
\title{Read Luminex Data}
\usage{
read_luminex_data(
  plate_filepath,
  layout_filepath = NULL,
  format = "xPONENT",
  plate_file_separator = ",",
  plate_file_encoding = "UTF-8",
  use_layout_sample_names = TRUE,
  use_layout_types = TRUE,
  use_layout_dilutions = TRUE,
  default_data_type = "Median",
  sample_types = NULL,
  dilutions = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{plate_filepath}{(\code{character(1)}) Path to the Luminex plate file.}

\item{layout_filepath}{(\code{character(1)}, optional) Path to the Luminex layout file.}

\item{format}{(\code{character(1)}, default = \code{'xPONENT'})
\itemize{
\item The format of the Luminex data file.
\item Supported formats: \code{'xPONENT'}, \code{'INTELLIFLEX'}, \code{'BIOPLEX'}.
}}

\item{plate_file_separator}{(\code{character(1)}, default = \code{','})
\itemize{
\item The delimiter used in the plate file (CSV format). Used only for the xPONENT format.
}}

\item{plate_file_encoding}{(\code{character(1)}, default = \code{'UTF-8'})
\itemize{
\item The encoding used for reading the plate file. Used only for the xPONENT format.
}}

\item{use_layout_sample_names}{(\code{logical(1)}, default = \code{TRUE})
\itemize{
\item Whether to use sample names from the layout file.
}}

\item{use_layout_types}{(\code{logical(1)}, default = \code{TRUE})
\itemize{
\item Whether to use sample types from the layout file (requires a layout file).
}}

\item{use_layout_dilutions}{(\code{logical(1)}, default = \code{TRUE})
\itemize{
\item Whether to use dilution values from the layout file (requires a layout file).
}}

\item{default_data_type}{(\code{character(1)}, default = \code{'Median'})
\itemize{
\item The default data type used if none is explicitly provided.
}}

\item{sample_types}{(\code{character()}, optional) A vector of sample types to override extracted values.}

\item{dilutions}{(\code{numeric()}, optional) A vector of dilutions to override extracted values.}

\item{verbose}{(\code{logical(1)}, default = \code{TRUE})
\itemize{
\item Whether to print additional information and warnings.
}}

\item{...}{Additional arguments. Ignored in this method. Here included for better integration with the pipeline}
}
\value{
A \link{Plate} object containing the parsed Luminex data.
}
\description{
Reads a Luminex plate file and returns a \link{Plate} object containing the extracted data.
Optionally, a layout file can be provided to specify the arrangement of samples on the plate.
}
\details{
The function supports two Luminex data formats:
\itemize{
\item \strong{xPONENT}: Used by older Luminex machines.
\item \strong{INTELLIFLEX}: Used by newer Luminex devices.
\item \strong{BIOPLEX}: Used by Bio-Rad Luminex devices.
}
}
\section{Workflow}{

\enumerate{
\item Validate input parameters, ensuring the specified format is supported.
\item Read the plate file using the appropriate parser:
\itemize{
\item xPONENT files are read using \code{\link[=read_xponent_format]{read_xponent_format()}}.
\item INTELLIFLEX files are read using \code{\link[=read_intelliflex_format]{read_intelliflex_format()}}.
\item BIOPLEX files are read using \code{\link[=read_bioplex_format]{read_bioplex_format()}}.
}
\item Post-process the extracted data:
\itemize{
\item Validate required data columns (\code{Median}, \code{Count}).
\item Extract sample locations and analyte names.
\item Parse the date and time of the experiment.
}
}
}

\section{File Structure}{

\itemize{
\item \strong{Plate File (\code{plate_filepath})}: A CSV file containing Luminex fluorescence intensity data.
\item \strong{Layout File (\code{layout_filepath})} (optional): An Excel or CSV file containing the plate layout.
\itemize{
\item The layout file should contain a table with \strong{8 rows and 12 columns}, where each cell corresponds to a well location.
\item The values in the table represent the sample names for each well.
}
}
}

\section{Sample types detection}{


The \code{\link[=read_luminex_data]{read_luminex_data()}} method automatically detects the sample types based on the sample names, unless provided the \code{sample_types} parameter.
The sample types are detected used the \code{\link[=translate_sample_names_to_sample_types]{translate_sample_names_to_sample_types()}} method.
In the documentation of this method, which can be accessed with command \code{?translate_sample_names_to_sample_types}, you can find the detailed description of the sample types detection.
\subsection{Duplicates in sample names}{

In some cases, we want to analyse the sample with the same name twice on one plate. The package allows for such situations, but we assume that the user knows what they are doing.

When importing sample names (either from the layout file or the plate file), the function will check for duplicates. If any are found, it will issue a warning like:

\strong{Duplicate sample names detected: A, B. Renaming to make them unique.}

Then it will add simple numeric suffixes (e.g. “.1”, “.2”) to the repeated sample names so that every name is unique while keeping the original text easy to recognize.
}
}

\examples{
# Read a Luminex plate file with an associated layout file
plate_file <- system.file("extdata", "CovidOISExPONTENT.csv", package = "SerolyzeR")
layout_file <- system.file("extdata", "CovidOISExPONTENT_layout.csv", package = "SerolyzeR")
plate <- read_luminex_data(plate_file, layout_file)

# Read a Luminex plate file without a layout file
plate_file <- system.file("extdata", "CovidOISExPONTENT_CO.csv", package = "SerolyzeR")
plate <- read_luminex_data(plate_file, verbose = FALSE)

}
