% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudoLikelihoodFunctions.R
\name{PseudoL}
\alias{PseudoL}
\title{Likelihood function under dependent censoring}
\usage{
PseudoL(theta, resData, X, W, lhat, cumL, cop, dist)
}
\arguments{
\item{theta}{Estimated parameter values/initial values for finite dimensional parameters}

\item{resData}{Data matrix with three columns;  Z = the observed survival time, d1 = the censoring indicator of T
and  d2 =  the censoring indicator of C.}

\item{X}{Data matrix with covariates related to T}

\item{W}{Data matrix with covariates related to C. First column of W should be ones}

\item{lhat}{The estimated hazard function obtained from the output of \code{\link{SolveL}}.}

\item{cumL}{The estimated cumulative hazard function from the output of \code{\link{SolveL}}.}

\item{cop}{Which copula should be computed to account for dependency between T and C. This argument can take
one of the values from \code{c("Gumbel", "Frank", "Normal")}. The default copula model is "Frank".}

\item{dist}{The distribution to  be used for the dependent censoring C. Only two distributions are allowed, i.e, Weibull
and lognormal distributions. With the value \code{"Weibull"} as the
default.}
}
\value{
maximized log-likelihood value
}
\description{
The \code{PseudoL} function  is maximized in order to
estimate the finite dimensional model parameters, including the dependency parameter.
This function assumes that the cumulative hazard function is known.
}
