#' eval_kmeans_clustersize
#'
#' @name eval_kmeans_clustersize
#' @param distmat a square matrix of cosine dist values generated by 'dist_matrix' function
#' @param k.max maximum number of clusters to evaluate default is 15
#' @param nboot number of bootstrap samples to determine gap statistic, default is 150
#' @details This internal function is used by viz_dendrogram and viz_network to convert raw semantic distance
#' values to a euclidean distance matrix, then it determines k (optimal cluster size by evaluating gap
#' statistic using Tibshirani's 1-SE method. It passes 'k' to the external function to cut the dendrogram or network by clusters
#' @importFrom cluster clusGap
#' @importFrom cluster maxSE
#' @importFrom stats kmeans
#' @return optimal_k an integer (K) representing optimal cluster size for distance matrix by gap statistic
#' @keywords internal
#' @noRd

eval_kmeans_clustersize <- function(distmat, k.max = 15, nboot = 150) {
  # Calculate gap statistic
  gap_stat <- cluster::clusGap(distmat, FUN = kmeans, K.max = k.max, B = nboot)

  # Extract optimal K (using Tibshirani's 1-SE method)
  optimal_k <- cluster::maxSE(
   gap_stat$Tab[, "gap"],
   gap_stat$Tab[, "SE.sim"],
    method = "Tibs2001SEmax")

  return(optimal_k)
}
