% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval_fastboost.R
\name{fastboost_interval}
\alias{fastboost_interval}
\title{Interval-response stability selection (fastboost variant)}
\usage{
fastboost_interval(
  X,
  Y_low,
  Y_high,
  func,
  B = 100,
  sample = c("uniform", "midpoint"),
  version = "glmnet",
  use.parallel = FALSE,
  seed = NULL,
  ...
)
}
\arguments{
\item{X}{Numeric matrix (n × p).}

\item{Y_low, Y_high}{Interval bounds in [0,1]. Rows with missing bounds are dropped.}

\item{func}{Function \code{function(X, y, ...)} returning a named coefficient
vector as in the other selectors (nonselected = 0).}

\item{B}{Number of interval resamples.}

\item{sample}{\code{"uniform"} (default) or \code{"midpoint"} for drawing pseudo-responses.}

\item{version}{Ignored (reserved for future).}

\item{use.parallel}{Use \code{parallel::mclapply} if available.}

\item{seed}{Optional RNG seed. Scoped via \code{\link[withr:with_seed]{withr::with_seed()}} so the caller's
RNG state is restored afterwards.}

\item{...}{Extra args forwarded to \code{func}.}
}
\value{
A list with:
\describe{
\item{betas}{\verb{B × (p+1)} matrix of coefficients over replicates.}
\item{freq}{Named vector of selection frequencies for each predictor.}
}
}
\description{
Repeats selection on interval-valued responses by sampling a pseudo-response
from each interval (uniformly or midpoint), tallying variable selection
frequencies across \code{B} replicates.
}
\examples{
# suppose you have interval data (Y_low, Y_high)
set.seed(1)
n <- 120; p <- 6
X <- matrix(rnorm(n*p), n, p); colnames(X) <- paste0("x",1:p)
mu <- plogis(X[,1] - 0.5*X[,2]); Y <- rbeta(n, mu*25, (1-mu)*25)
Y_low <- pmax(0, Y - 0.05); Y_high <- pmin(1, Y + 0.05)
fb <- fastboost_interval(X, Y_low, Y_high,
       func = function(X,y) betareg_glmnet(X,y, choose="bic", prestandardize=TRUE),
       B = 40)
sort(fb$freq, decreasing = TRUE)
}
