% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{CRPS}
\alias{CRPS}
\title{Continuous Ranked Probability Score}
\usage{
CRPS(
  dt,
  f,
  o = "obs",
  by = by_cols_ens_fc_score(),
  pool = "year",
  mem = "member",
  dim.check = TRUE,
  ens_size_correction = FALSE
)
}
\arguments{
\item{dt}{Data table containing predictions and observations.}

\item{f}{column name of the forecasts. May not be called \code{'f'}}

\item{o}{column name of the observations.}

\item{by}{column names of grouping variables, all of which need to be columns in dt.
Default is to group by all instances of month, season, lon, lat, system and lead_time that are columns in dt.}

\item{pool}{column name(s) for the variable(s) over which is averaged. Typically just 'year'.}

\item{mem}{Name of the column identifying the ensemble member.}

\item{dim.check}{Logical. If True, a simple test whether the dimensions match up is conducted:
The data table should only have one row for each level of c(by,pool,mem)}

\item{ens_size_correction}{logical. If TRUE, the CRPS is corrected for sample size (see Ferro et al. 2008: 'On the effect of ensemble size on the discrete and continuous
ranked probability scores'). This is slower, but you should do it if you compare ensembles of different size.}
}
\value{
A data table with the scores
}
\description{
Taking CRPSs of ensemble forecasts stored in long data tables:
}
\examples{
dt = data.table(fc = 1:4,obs = c(4,4,7,7),member = c(1,2,1,2),year = c(1999,1999,2000,2000))
CRPS(dt,f = 'fc')


}
