% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_NormalizedDopplerFreq2DopplerFreq}
\alias{seasonder_NormalizedDopplerFreq2DopplerFreq}
\title{Convert Normalized Doppler Frequencies to Doppler Frequencies}
\usage{
seasonder_NormalizedDopplerFreq2DopplerFreq(
  seasonder_cs_object,
  doppler_values
)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeR} cross-spectral object containing metadata about the Doppler bins.}

\item{doppler_values}{A numeric vector specifying the normalized Doppler frequencies to be converted into Doppler frequencies (Hz).}
}
\value{
A numeric vector of Doppler frequencies (in Hz) corresponding to the input normalized Doppler frequencies.
}
\description{
This function converts normalized Doppler frequencies into their corresponding Doppler frequencies (in Hz) within a \code{SeaSondeR} object.
}
\details{
The function follows these steps:
\enumerate{
\item Calls \code{\link{seasonder_NormalizedDopplerFreq2Bins}} to convert the input normalized Doppler frequencies into Doppler bin indices.
\item Calls \code{\link{seasonder_Bins2DopplerFreq}} to obtain the corresponding Doppler frequencies in Hz.
}

The relationship between the normalized and absolute Doppler frequencies is defined as:
\deqn{f_{doppler} = f_{norm} \times f_{bragg}}
where:
\itemize{
\item \eqn{f_{doppler}} is the Doppler frequency in Hz,
\item \eqn{f_{norm}} is the normalized Doppler frequency,
\item \eqn{f_{bragg}} is the Bragg frequency, computed based on radar wavelength.
}
}
\seealso{
\code{\link{seasonder_NormalizedDopplerFreq2Bins}} for converting normalized Doppler frequencies to bin indices.
\code{\link{seasonder_Bins2DopplerFreq}} for converting bin indices to Doppler frequencies in Hz.
}
