% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICCheckEigenValueRatio}
\alias{seasonder_MUSICCheckEigenValueRatio}
\title{Validate Eigenvalue Ratio Using MUSIC Algorithm}
\usage{
seasonder_MUSICCheckEigenValueRatio(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing the MUSIC solutions and related data.}
}
\value{
The updated SeaSondeRCS object with the following modifications:
\itemize{
\item A new column \code{eigen_values_ratio} in the MUSIC data.
\item A logical column \code{P1_check} indicating whether each solution passes the P1 test.
\item Updated \code{retained_solution} values for solutions that fail the test.
}
}
\description{
This function implements the P1 test for solutions derived using the MUSIC algorithm.
The test checks the ratio between the largest and the second-largest eigenvalues, which
serves as an indicator of signal quality.
}
\details{
The P1 test is based on the ratio of the largest eigenvalue (lambda1) to the second-largest eigenvalue (lambda2):

Ratio = lambda1 / lambda2

This ratio is compared to a threshold defined in the MUSIC parameters to determine whether the solution
is considered valid. Solutions failing this test are marked as "single."
}
\seealso{
\code{seasonder_getSeaSondeRCS_MUSIC}, \code{seasonder_setSeaSondeRCS_MUSIC}
}
