% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od_resource.R
\name{od_resource}
\alias{od_resource}
\alias{od_cache_dir}
\alias{od_cache_clear}
\alias{od_cache_file}
\alias{od_json}
\alias{od_resource_all}
\title{Resource management for open.data}
\usage{
od_cache_dir(dir = NULL)

od_cache_clear(id, server = "ext")

od_cache_file(id, suffix = NULL, timestamp = NULL, ..., server = "ext")

od_resource(id, suffix = NULL, timestamp = NULL, server = "ext")

od_json(id, timestamp = Sys.time() - 3600, server = "ext")

od_resource_all(id, json = od_json(id), server = "ext")
}
\arguments{
\item{dir}{If \code{NULL}, the cache directory is returned. Otherwise, the
cache directory will be updated to \code{dir}.}

\item{id}{A database id}

\item{server}{the OGD-Server to use to load update the resources in case they
are outdated. \code{"ext"} for the external server (the default) od \code{"red"} for
the editing server.}

\item{suffix}{A suffix for the resource: \code{"HEADER"} or a field code.}

\item{timestamp}{A timestamp in \code{POSIXct} format. If provided, the
cached resource will be updated if it is older than that value. Otherwise
it will be downloaded only if it does not exist in the cache.}

\item{...}{For internal use}

\item{json}{The JSON file belonging to the dataset}
}
\value{
For \code{\link[=od_cache_file]{od_cache_file()}} and \code{\link[=od_resource]{od_resource()}}, the returned objects
contain a hidden attribute \code{attr(., "od")} about the time used for
downloading and parsing the resource. \code{\link[=od_resource_all]{od_resource_all()}} converts these
hidden attribute into columns.
}
\description{
Helper functions for caching and parsing open.data resources.
}
\details{
\code{od_cache_clear(id)} removes all files belonging to the specified id.

By default, downloaded json files will "expire" in one hour or 3600 seconds.
That is, if a json is requested, it will be reused from the cache unless the
\code{\link[=file.mtime]{file.mtime()}} is more than one hour behind \code{\link[=Sys.time]{Sys.time()}}.
}
\examples{
# get the current cache directory
od_cache_dir()

# Get paths to cached files
od_cache_file("OGD_veste309_Veste309_1")
od_cache_file("OGD_veste309_Veste309_1", "C-A11-0")

# get a parsed verison of the resource
od_resource("OGD_veste309_Veste309_1", "C-A11-0")

# get json metadata about a dataset
od_json('OGD_veste309_Veste309_1')

# Bundle all resources
od_resource_all("OGD_veste309_Veste309_1")
}
